/** @file   carcontroller
 * @brief   Implementation of CarController - class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:43 $
 * @author  Tomi Lamminsaari
 */

#include "carcontroller.h" // class's header file
#include "utils.h"


namespace WeWantWar {


/** Constructor
 */
CarController::CarController( GameObject* pObj ) :
  WaypointController( pObj ),
  m_waitingCounter( -1 ),
  m_waitingCarCounter( -1 )
{
	// insert your code here
}

/** Destructor
 */
CarController::~CarController()
{
	// insert your code here
}



///
/// Methods
/// =======

/** Updates this controller
 */
void CarController::update()
{
  m_counter -= 1;
  if ( m_counter > 0 ) {
    return;
  }
  
  if ( this->validRoute() == false ) {
    // We're not having a valid route, so we exit.
    this->reset();
    m_counter = 20;
    return;
  }
  
  // Check if we've reached our current waypoint.
  if ( this->waypointReached() == true ) {
    // Yes we have. Now we start heading towards the next waypoint.
    this->step();
  }
  
  // If there is someone in front of use. We stop
  GameObject* pO = this->getGameObject();
  eng2d::Vec2D checkPoint( 0, -40 );
  checkPoint.rotate( pO->angle() );
  checkPoint += pO->position();
  
  if ( Utils::creatureInsideCircle( checkPoint, 25 ) == true ) {
    this->reset();
    m_counter = 15;
    m_waitingCounter += 1;
    if ( m_waitingCounter > 8 ) {
      m_shoot = 1;
      m_waitingCounter = rand() % 3;
    } else {
      m_shoot = 0;
    }
    return;
  }
  
  GameObject* pO2 = Utils::carInsideCircle( checkPoint, 25 );
  if ( pO2 != 0 ) {
    this->reset();
    m_waitingCarCounter += 1;
    if ( m_waitingCarCounter > 4 ) {
      m_turn = (rand() % 10 < 5 ) ? -1 : 1;
      m_forward = 1;
      m_counter = rand() % 10 + 5;
      m_waitingCarCounter = 0;
      return;
    }
    m_counter = rand() % 10 + 5;
    return;
  }
    
  m_waitingCounter = 0;
  m_waitingCarCounter = 0;
  
  // If our nose points towards the waypoint, we move
  this->reset();
  if ( this->isFacingWaypoint( 20 ) == true ) {
    m_forward = 2;
    m_counter = 4;
    
  } else {
    // We're not facing the waypoint. We keep on turning.
    m_turn = this->findShortestTurn();
    m_forward = 1;
    m_counter = 1;
  }
}


} // end of namespace
